import java.awt.*;

public class JAPI_Textfield extends TextField
{

	int w=0,h=0;

	public JAPI_Textfield (int w)
	{
		super(w);
	}

	public void setSize(int dw, int dh)
	{
		w = dw>0 ? dw : 0;
		h = dh>0 ? dh : 0;
		super.setSize(w,h);
	}

	public void setColumns(int c)
	{
		if((w=getPreferredSize(c).width)>0)
			super.setSize(w,h);
	}

	public int getColumns()
	{
		int c=0;
		while(getPreferredSize(c).width < getSize().width)
			c++;
		return(--c);
	}

	public Dimension preferredSize()
	{
		Dimension dim = super.preferredSize();
		dim.width  = w>0 ? w : dim.width;
		dim.height = h>0 ? h : dim.height;
		return(dim);
	}

	public Dimension minimumSize()
	{
		Dimension dim = super.minimumSize();
		dim.width  = w>0 ? w : dim.width;
		dim.height = h>0 ? h : dim.height;
		return(dim);
	}

}