Unit Strings;

{$X+}

Interface
type String = String(255);

procedure Str(i: integer; var s: String);
function StrPCopy(cstr: PChar; s: String): PChar;
function StrCat(dest,src: PChar): PChar;
function StrComp(s1,s2: PChar): integer;
function StrLen(s: PChar): integer;

Implementation

procedure Str(i: integer; var s: String);
begin
	writestr(s,i);
end;

function StrPCopy(cstr: PChar; s: String): PChar;
var i:integer;
begin
	for i := 1 to length(s) do
		cstr[i-1] := s[i];
	cstr[length(s)] := chr(0);
	StrPCopy := s;
end;

function StrCat(dest,src: PChar): PChar;
var i,len:integer;
begin
    len := 0;
    while (dest[len] <> chr(0)) do
    	inc(len);
    i:=0;
    while (src[i] <> chr(0)) do begin
		dest[len+i] := src[i];
		inc(i);
	end;
	dest[len+i] := chr(0);		
	StrCat := dest;
end;

function StrComp(s1,s2: PChar): integer;
var i,len : integer;
begin
	len:=StrLen(s1);
	if(len>StrLen(s2)) then
		len:=StrLen(s2);

   	StrComp := 0;
    for i := 0 to len do begin
    	if(s1[i] <> s2[i]) then begin
    	    if(s1[i] < s2[i]) then
    	        StrComp := -1
    	    else
    	        StrComp := 1;
    	end;
        break;
    end;
end;

function StrLen(s: PChar): integer;        	
var len : integer;
begin
	len:=0;
    while (s[len] <> chr(0)) do
    	inc(len);
    StrLen:=len;
end;

end.