program colorpicker;

{$X+}
{$ifdef GPC}
	uses japi,Strings;
{$else}
	uses japi,Sysutils;
{$endif}

function j_colorpicker(frame: integer; var r,g,b: int): boolean;

var
    dialog,obj,rscroll,gscroll,bscroll,
    rlabel,glabel,blabel,panel1,panel2,canvas,
    ok,cancel                                  : int;
    xpos,ypos                                  : int;
    val                                        : String;
    cstr                                       : PChar;
begin
    getmem(cstr,255);
    
    j_disable(frame);
    j_colorpicker := false;

    dialog := j_dialog(frame,'Colorpicker');
    j_setnamedcolorbg(dialog,J_WHITE);
    j_setborderlayout(dialog);
    panel1 := j_panel(dialog);
    j_setborderpos(panel1,J_LEFT);
    j_setborderlayout(panel1);

    panel2 := j_panel(panel1);
    j_setborderpos(panel2,J_TOP);
    j_setgridlayout(panel2,0,3);
    rlabel := j_label(panel2,'255');
    glabel := j_label(panel2,'255');
    blabel := j_label(panel2,'255');

    panel2 := j_panel(panel1);
    j_setgridlayout(panel2,0,3);
    j_sethgap(panel2,20);
    rscroll := j_vscrollbar(panel2);
    gscroll := j_vscrollbar(panel2);
    bscroll := j_vscrollbar(panel2);
    j_setmax(rscroll,265);
    j_setmax(gscroll,265);
    j_setmax(bscroll,265);
    j_setnamedcolorbg(rscroll,J_RED);
    j_setnamedcolorbg(gscroll,J_GREEN);
    j_setnamedcolorbg(bscroll,J_BLUE);
    j_setvalue(rscroll,ord(r));
    j_setvalue(gscroll,ord(g));
    j_setvalue(bscroll,ord(b));

    panel1 := j_panel(dialog);
    j_setborderpos(panel1,J_BOTTOM);
    j_setflowlayout(panel1,J_HORIZONTAL);
    ok     := j_button(panel1,'   OK   ');
    cancel := j_button(panel1,'Cancel');

    canvas := j_canvas(dialog,200,200);

    j_pack(dialog);
    j_getpos(frame,xpos,ypos);
    xpos := xpos + ((j_getwidth(frame)-j_getwidth(dialog)) div 2);
    ypos := ypos + ((j_getheight(frame)-j_getheight(dialog)) div 2);
    j_setpos(dialog,xpos,ypos);
    j_show(dialog);
    
    obj:=0;
    while((obj <>cancel) and (obj <> dialog)) do begin
   
        j_setcolorbg(canvas,j_getvalue(rscroll),j_getvalue(gscroll),j_getvalue(bscroll));
        Str(j_getvalue(rscroll),val);
        j_settext(rlabel,StrPCopy(cstr,val));
        Str(j_getvalue(gscroll),val);
        j_settext(glabel,StrPCopy(cstr,val));
        Str(j_getvalue(bscroll),val);
        j_settext(blabel,StrPCopy(cstr,val));

        obj :=  j_nextaction;

        if(obj = ok) then begin
            j_colorpicker := true;
            r := j_getvalue(rscroll);
            g := j_getvalue(gscroll);
            b := j_getvalue(bscroll);
            break;
        end;
    end;

    j_dispose(dialog);
    j_enable(frame);
    
end;

var 
    frame,menubar,jfile,color,quit,obj   : integer;
    r,g,b                                : int;

begin    
    if( j_start = false ) then begin
        writeln('cannot connect to JAPI Kernel');
        halt;   
    end;

    frame   := j_frame('Colorpicker Demo');
    menubar := j_menubar(frame);
    jfile   := j_menu(menubar,'File');
    color   := j_menuitem(jfile,'Color');
    quit    := j_menuitem(jfile,'Quit');

    r := 0; 
    g := 0;
    b := 0;
    j_setcolorbg(frame,r,g,b);
    j_show(frame);

    while(true) do begin
    
        obj := j_nextaction;

        if(obj = color) then
            if(j_colorpicker(frame,r,g,b)) then
                j_setcolorbg(frame,r,g,b);

        if((obj = quit) or (obj = frame)) then
            break;
    end;

    j_quit;
end.