program componentlistener;

{$X+}

{$ifdef GPC}
	uses japi,Strings;
{$else}
	uses japi,Sysutils;
{$endif}


var 
    frame,obj,text,resized,moved,hidden,shown   : integer;
    pstr,wstr,hstr                         : String;
    cstr                                   : PChar;

begin    
    
    getmem(cstr,256);
    
    if( j_start = false ) then begin
        writeln('cannot connect to JAPI Kernel');
        halt;   
    end;
        
    frame   := j_frame('component listener');
    j_setgridlayout(frame,1,1);

    text    := j_textarea(frame,80,25);

    resized := j_componentlistener(text,J_RESIZED);
    moved   := j_componentlistener(frame,J_MOVED);
    hidden  := j_componentlistener(text,J_HIDDEN);
    shown   := j_componentlistener(text,J_SHOWN);

    j_show(frame);
    j_pack(frame);
        
    obj:=0;
    while(obj<>frame) do begin            
            
        obj:=j_nextaction;

        if(obj=resized) then begin
            Str(j_getcolumns(text),wstr);
            Str(j_getrows(text),hstr);
            pstr := 'resized to '+wstr+' rows '+hstr+' columns'+#10;
            j_appendtext(text,StrPCopy(cstr,pstr));
        end;

        if(obj=moved) then begin
            j_appendtext(text,'Frame moved'+#10);
            if(j_isvisible(text)) then begin
                j_settext(frame,'Move again to see the text!');
                j_hide(text);
                end
            else begin
                j_settext(frame,'Component Listener');
                j_show(text);
            end;
        end;
		
        if(obj=hidden) then
            j_appendtext(text,'Text hidden'+#10);

        if(obj=shown) then
            j_appendtext(text,'Text shown'+#10);

    end;

    j_quit;           
    
end.
