program cursor;

uses japi;

var 
    frame,menubar,jfile,quit,obj               : integer;
    jcursor,def,cross,hand,move,text,wait       : integer;
    resize,nr,ner,er,ser,sr,swr,wr,nwr       : integer;        

begin    
          
    if( j_start = false ) then begin
        writeln('cannot connect to JAPI Kernel');
        halt;   
    end;

    frame   := j_frame('Cursor Demo');
    menubar := j_menubar(frame);
    jfile   := j_menu(menubar,'File');
    quit    := j_menuitem(jfile,'Quit');

    jcursor  := j_menu(menubar,'Cursor');
    def     := j_menuitem(jcursor,'Default');
    cross   := j_menuitem(jcursor,'Crosshair');
    text    := j_menuitem(jcursor,'Text');
    wait    := j_menuitem(jcursor,'Wait');
    hand    := j_menuitem(jcursor,'Hand');
    move    := j_menuitem(jcursor,'Move');

    resize  := j_menu(menubar,'Resize');
    nr      := j_menuitem(resize,'North Resize');
    ner     := j_menuitem(resize,'North East Resize');
    er      := j_menuitem(resize,'East Resize');
    ser     := j_menuitem(resize,'South East Resize');
    sr      := j_menuitem(resize,'South Resize');
    swr     := j_menuitem(resize,'South West Resize');
    wr      := j_menuitem(resize,'West Resize');
    nwr     := j_menuitem(resize,'North West Resize');
    
    
    j_show(frame);
    
    obj := 0;
    while((obj <> quit) and (obj <> frame)) do begin            
        
        obj:=j_nextaction;
        
        if(obj = def)   then j_setcursor(frame,J_DEFAULT_CURSOR);
        if(obj = cross) then j_setcursor(frame,J_CROSSHAIR_CURSOR);
        if(obj = hand)  then j_setcursor(frame,J_HAND_CURSOR);
        if(obj = move)  then j_setcursor(frame,J_MOVE_CURSOR);
        if(obj = text)  then j_setcursor(frame,J_TEXT_CURSOR);
        if(obj = wait)  then j_setcursor(frame,J_WAIT_CURSOR);     
        
        if(obj = nr)    then j_setcursor(frame,J_N_RESIZE_CURSOR);
        if(obj = ner)   then j_setcursor(frame,J_NE_RESIZE_CURSOR);
        if(obj = er)    then j_setcursor(frame,J_E_RESIZE_CURSOR);
        if(obj = ser)   then j_setcursor(frame,J_SE_RESIZE_CURSOR);
        if(obj = sr)    then j_setcursor(frame,J_S_RESIZE_CURSOR);
        if(obj = swr)   then j_setcursor(frame,J_SW_RESIZE_CURSOR);
        if(obj = wr)    then j_setcursor(frame,J_W_RESIZE_CURSOR);
        if(obj = nwr)   then j_setcursor(frame,J_NW_RESIZE_CURSOR);

    end;   
     
    j_quit;

end.
