program example_mandel;

{$x+}

{$ifdef GPC}
	uses japi,Strings;
{$else}
	uses japi,Sysutils;
{$endif}

procedure drawgraphics(drawable,xmin,ymin,xmax,ymax : integer);
var image,i,fntsize,x,y:integer;
    val    :  String;
    tmpstr : PChar;
begin
    getmem(tmpstr,255);
    fntsize:=10;
    
    j_setfontsize(drawable,fntsize);
    j_setnamedcolor(drawable,J_RED);

    (* Drawings *)
    j_drawline(drawable,xmin,ymin,xmax-1,ymax-1);
    j_drawline(drawable,xmin,ymax-1,xmax-1,ymin);
    j_drawrect(drawable,xmin,ymin,xmax-xmin-1,ymax-xmin-1);

    j_setnamedcolor(drawable,J_BLACK);
    j_drawline(drawable,xmin,ymax-30,xmax-1,ymax-30);
    Str(xmax,val);
    StrPCopy(tmpstr,val);
    j_drawstring(drawable,round(xmax/2-j_getstringwidth(drawable,tmpstr)/2),
                 ymax-40,tmpstr);

    j_drawline(drawable,xmin+30,ymin,xmin+30,ymax-1);
    Str(ymax,val);
    j_drawstring(drawable,xmin+50,40,StrPCopy(tmpstr,val));

    j_setnamedcolor(drawable,J_MAGENTA);
    for i:=1 to 10 do
    	j_drawoval(drawable,round(xmin+(xmax-xmin)/2),round(ymin+(ymax-ymin)/2),
                            round((xmax-xmin)/20*i),round((ymax-ymin)/20*i));

    (* Text *)
    j_setnamedcolor(drawable,J_BLUE);
    y:=ymin;
    for i:=5 to 22 do begin
	j_setfontsize(drawable,i);
	x := xmax-j_getstringwidth(drawable,'JAPI Test Text');
    	y := y+j_getfontheight(drawable);
    	j_drawstring(drawable,x,y,'JAPI Test Text');
    end;

    (* Images *)
    image := j_loadimage('images/twux.gif');
    if(image > 0) then begin
        j_drawimage(drawable,image,100,200);
        j_drawscaledimage(drawable,image,10,0,35,30,100,300,110,138);
    end;
end;



var frame,printer,canvas,image,obj,
    menubar,jfile,print,save,quit      : int;
begin
    j_setdebug(4);

    if( j_start = false ) then begin
        writeln('cannot connect to server');
        halt;   
    end;
    
    frame   := j_frame('Drawables');
    j_setborderlayout(frame);

    menubar := j_menubar(frame);
    jfile    := j_menu(menubar,'File');
    print   := j_menuitem(jfile,'Print');
    save    := j_menuitem(jfile,'Save BMP');
    quit    := j_menuitem(jfile,'Quit');
    canvas  := j_canvas(frame,400,600);
    j_pack(frame);
    j_show(frame);

    drawgraphics(canvas,0,0,j_getwidth(canvas),j_getheight(canvas));
    obj:=0;
    while((obj <> frame) and (obj <> quit)) do begin
  
    	obj:=j_nextaction;

    	if(obj = canvas) then begin
	    j_setnamedcolorbg(canvas,J_WHITE);
	    drawgraphics(canvas,10,10,j_getwidth(canvas)-10,j_getheight(canvas)-10);
	end;

    	if(obj = print) then begin
    	    printer := j_printer(frame);
    	    if(printer > 0 ) then begin
	        drawgraphics(printer,40,40,j_getwidth(printer)-80,j_getheight(printer)-80);
	    	j_print(printer);
	    end;	
    	end;

    	if(obj = save) then begin
	    (* NOTE: sometimes problems with WinNT 24 Bit Colordepth (use 16 Bit) *)
    	    image := j_image(600,800);
	    drawgraphics(image,0,0,600,800);
    	    if(not j_saveimage(image,'test.bmp',J_BMP)) then
	    	j_alertbox(frame,'Problems','Cant save image','OK');
     	end;
    end;

    j_quit;
end.


