program flowlayout;

uses japi;


var 
    obj,frame,align,orient,fill,pack,
    alignment,orientation             : integer;
    dofill                            : boolean;
begin	
    alignment   := J_TOP;
    orientation := J_HORIZONTAL;
    dofill      := false;
    	
    if( j_start = false ) then begin
        writeln('cannot connect to JAPI Kernel');
        halt;   
    end;

    frame   := j_frame('Flow Layout Demo');
    j_setsize(frame,800,600);

    j_setflowlayout(frame,orientation);
    j_setalign(frame,alignment);

    align   := j_button(frame,'alignment');
    orient  := j_button(frame,'orientation');
    fill    := j_button(frame,'fill');
    pack    := j_button(frame,'pack');

    j_sethgap(frame,10);
    j_setvgap(frame,10);


    j_setsize(align,100,100);
    j_setsize(orient,200,200);

    j_show(frame);

    obj := 0;
    while  (obj <> frame) do begin
    
    	obj := j_nextaction;
    	
        if(obj = align) then begin
            case (alignment) of
                J_LEFT        : alignment := J_CENTER;
                J_CENTER      : alignment := J_RIGHT;
                J_RIGHT       : alignment := J_TOP;
                J_TOP         : alignment := J_BOTTOM;
                J_BOTTOM      : alignment := J_TOPLEFT;
                J_TOPLEFT     : alignment := J_TOPRIGHT;
                J_TOPRIGHT    : alignment := J_BOTTOMLEFT;
                J_BOTTOMLEFT  : alignment := J_BOTTOMRIGHT;
                J_BOTTOMRIGHT : alignment := J_LEFT;
            end;
            j_setalign(frame,alignment);
        end;

        if(obj = pack) then
            j_pack(frame);

        if(obj = fill) then begin
            if(dofill) then
            	dofill := false
            else
            	dofill := true;
            j_setflowfill(frame,dofill);
        end;

        if(obj = orient) then begin
            if(orientation = J_VERTICAL) then
            	orientation := J_HORIZONTAL
            else
            	orientation := J_VERTICAL;
            j_setflowlayout(frame,orientation);
            j_setalign(frame,alignment);
            j_setflowfill(frame,dofill);
        end;
    
    end;
    j_quit;

end.
