program image_example;

uses japi;

var 
    frame,menubar,jfile,   
    insets,obj,canvas,
    quit,plus,minus : int; 
    w,h            : int;
    
begin
    j_setdebug(3);

    if( j_start = false ) then begin
        writeln('cannot connect to server');
        halt;   
    end;

    frame   := j_frame('Insets Demo');
    j_setborderlayout(frame);

    menubar := j_menubar(frame);
    jfile    := j_menu(menubar,'File');
    insets  := j_menu(menubar,'Insets');
    quit    := j_menuitem(jfile,'Quit');
    plus    := j_menuitem(insets,'Insets + 10');
    minus   := j_menuitem(insets,'Insets - 10');

    canvas  := j_canvas(frame,320,240);
    j_setnamedcolor(canvas,J_RED);

    j_pack(frame);
    j_show(frame);

    obj := 0;
    while((obj <> quit) and (obj <> frame)) do begin      
    
        obj := j_nextaction;

        if(obj = canvas) then begin
            w := j_getwidth(canvas)-1;
            h := j_getheight(canvas)-1;
            j_drawrect(canvas,0,0,w,h);
            j_drawline(canvas,0,0,w,h);
            j_drawline(canvas,0,h,w,0);
        end;
		
	if(obj = plus) then
            j_setinsets(frame,j_getinsets(frame,J_TOP)+10,j_getinsets(frame,J_BOTTOM)+10,
		              j_getinsets(frame,J_LEFT)+10,j_getinsets(frame,J_RIGHT)+10);
	if(obj = minus) then
            j_setinsets(frame,j_getinsets(frame,J_TOP)-10,j_getinsets(frame,J_BOTTOM)-10,
		              j_getinsets(frame,J_LEFT)-10,j_getinsets(frame,J_RIGHT)-10);
        
    end;
    
    j_quit;

end.
   