program mandel1;

uses japi;


function mandel(zre:real; zim:real; maxiter:integer) : integer;
var
    x,y,tmp,betrag  : real;
    iter,break      : integer;
    
begin
    x:=0.0;
    y:=0.0;
    iter:=0;
    betrag:=0.0;
    break:=0;
    
    while (iter < maxiter) and (break = 0) do begin
        inc(iter);
        tmp := x*x-y*y+zre;
        y := 2*x*y+zim;
        x := tmp;
        betrag := (x*x + y*y);
        if (betrag > 4.0) then break := 1;     
    end;
    mandel := iter;
end;    

var 
    x,y,do_work,it,
    frame,menubar,
    jfile,calc,
    quit,start,stop,
    canvas,obj,            
    breite,hoehe            : integer;
    zre,zim                 : real;
    xstart,ystart,xend,yend : real;
    
begin
    
    do_work := 0;
    breite  := 325;
    hoehe   := 240;
        
    (* mandelbrot area *)
    xstart := -1.8;
    xend   :=  0.8;
    ystart := -1.0;
    yend   :=  1.0;
    
    j_setdebug(3);
    
    if( j_start = false ) then begin
        writeln('cannot connect to JAPI Kernel');
        halt;   
    end;

    frame   := j_frame('Mandelbrot');
    menubar := j_menubar(frame);
    jfile   := j_menu(menubar,'File');
    calc    := j_menu(menubar,'Calc'); 
    quit    := j_menuitem(jfile,'Quit');
    start   := j_menuitem(calc,'Start');
    stop    := j_menuitem(calc,'Stop');

    j_setborderlayout(frame);     
    canvas  := j_canvas(frame,breite,hoehe);    

    j_pack(frame);
    j_show(frame);
    
    x:=-1;
    y:=-1;
    
    while(true) do begin
        
        if(do_work <> 0) then
            obj := j_getaction
        else
            obj := j_nextaction;
                
        if(obj = quit) then
            break;
        if(obj = start) then
            do_work := 1;
        if(obj = stop) then
            do_work := 0;
            
        if(do_work = 1) then begin
            x := (x+1) mod breite;
            if(x = 0) then
                y := (y+1) mod hoehe;
            if((x=breite-1) and (y=hoehe-1)) then
                do_work :=0
            else begin
                zre := xstart + x*(xend-xstart)/breite;
                zim := ystart + y*(yend-ystart)/hoehe;
                it  := mandel(zre,zim,512);
                j_setcolor(canvas,it*11,it*13,it*17);
                j_drawpixel(canvas,x,y);                
            end;
         end;                
        
        if(obj=canvas) then begin
            breite := j_getwidth(canvas);
            hoehe  := j_getheight(canvas);
            x := -1;
            y := -1;
        end;
    end;

    j_quit;

end.

