program example_mandel;

uses japi;

type str = String[255];


function mandel(zre:real; zim:real; maxiter:integer) : integer;
var
    x,y,tmp,betrag  : real;
    iter,break      : integer;
    
begin
    x:=0.0;
    y:=0.0;
    iter:=0;
    betrag:=0.0;
    break:=0;
    
    while (iter < maxiter) and (break = 0) do begin
        inc(iter);
        tmp := x*x-y*y+zre;
        y := 2*x*y+zim;
        x := tmp;
        betrag := (x*x + y*y);
        if (betrag > 4.0) then break := 1;     
    end;
    mandel := iter;
end;    



const 
    breite=325;
    hoehe=240;

var 
    x,y,it,
    frame,menubar,
    jfile,calc,
    quit,start,stop,
    canvas,obj              : integer;
    zre,zim                 : real;
    xstart,ystart,xend,yend : real;
    do_work                 : boolean;
    r,g,b                   : array[0..breite] of int;
begin
    
    do_work:=false;
        
    (* mandelbrot area *)
    xstart := -1.8;
    xend   :=  0.8;
    ystart := -1.0;
    yend   :=  1.0;
    
    j_setdebug(3);
    
    if( not j_start ) then begin
        writeln('cannot connect to server');
        halt;   
    end;
        
    (* Generate Graphical Objects *)
    
    frame   := j_frame('Mandelbrot');
    
    menubar := j_menubar(frame);
    jfile   := j_menu(menubar,'File');
    calc    := j_menu(menubar,'Calc');
    quit    := j_menuitem(jfile,'Quit');
    start   := j_menuitem(calc,'Start');
    stop    := j_menuitem(calc,'Stop ');
    j_show(frame);
     
    canvas  := j_canvas(frame,breite,hoehe);    
    j_setpos(canvas,10,60);
    j_show(frame);
    j_pack(frame);
    
    x:=-1;
    y:=-1;
    
    while(true) do begin
        
        if(do_work) then
            obj := j_getaction
        else
            obj := j_nextaction;
                
        if(obj = quit)  then break;
        if(obj = start) then begin
            do_work := true;
            x := -1;
            y := -1;
            j_setnamedcolorbg(canvas,J_WHITE);
        end;
        
        if(obj = stop)  then do_work := false;
            
        if(do_work) then begin
            inc(y);
            if(y = hoehe) then begin
                y := 0;
                do_work := false;
                end
            else begin
                for x:=0 to breite do begin
                    zre  := xstart + x*(xend-xstart)/breite;
                    zim  := ystart + y*(yend-ystart)/hoehe;
                    it   := mandel(zre,zim,512);
                    r[x] := it*11;
                    g[x] := it*13;
                    b[x] := it*17;
                end;
                j_drawimagesource(canvas,0,y,breite,1,r[0],g[0],b[0]);
            end;
        end;                
        
    end;

    j_quit;

end.

