program menu;

{$x+}

{$ifdef GPC}
	uses japi,Strings;
{$else}
	uses japi,Sysutils;
{$endif}

var 
    frame,menubar,submenu,jfile,
    edit,options,help,obj,
    open,save,quit,about,cut,
    copy,paste,enable,settings      : integer;
    inhalt                          : pchar;
begin    

    getmem(inhalt,255);
    
    j_setdebug(4);
              
    if( j_start = false ) then
        begin
            writeln('cannot connect to JAPI Kernel');
            halt;   
        end;
        
    (* Generate Graphical Objects *)
    frame    := j_frame('');
    menubar  := j_menubar(frame);
    jfile    := j_menu(menubar,'File');
    edit     := j_menu(menubar,'Edit');
    options  := j_menu(menubar,'Options');
    help     := j_helpmenu(menubar,'Help');
    submenu  := j_menu(options,'Settings');
        
    open     := j_menuitem(jfile,'Open');
    save     := j_menuitem(jfile,'Save');
    j_seperator(jfile);     
    quit     := j_menuitem(jfile,'Quit');
    j_disable(save);    
    j_setshortcut(quit,'q');
    
    cut      := j_menuitem(edit,'Cut');
    copy     := j_menuitem(edit,'Copy');
    paste    := j_menuitem(edit,'Paste');
    
    about    := j_menuitem(help,'About');
    
    enable   := j_checkmenuitem(submenu,'Enable Settings');
    settings := j_menuitem(submenu,'Settings');
    j_disable(settings);    
    
    j_show(frame);
    
    (* Waiting for actions *)
    while(true) do begin

        obj := j_nextaction;
                
        if(obj = enable) then begin
            if(j_getstate(enable)) then
                j_enable(settings)
            else
                j_disable(settings);
        end;
        
        if(obj = cut) then begin
            j_gettext(cut,inhalt);
            if(StrComp(inhalt,'Cut')=0) then
                j_settext(cut,'Ausschneiden')
            else
                j_settext(cut,'Cut');
        end;
        
        if(obj = copy) then begin
            j_gettext(copy,inhalt);
            if(StrComp(inhalt,'Copy')=0) then
                j_settext(copy,'Kopieren')
            else
                j_settext(copy,'Copy');
        end;
        
        if(obj = paste) then begin
            j_gettext(paste,inhalt);
            if(StrComp(inhalt,'Paste')=0) then
                j_settext(paste,'Einfuegen')
            else
                j_settext(paste,'Paste');
        end;
                
        if((obj = quit) or (obj = frame)) then
            break;

    end;
    
    j_quit;

end.
