program mouselistener;

uses japi;


var 
    frame,obj,canvas1,canvas2,x,y,startx,starty   : int;
    pressed,released,moved,dragged,entered,exited : int;

begin    

    if( j_start = false ) then begin
        writeln('cannot connect to JAPI Kernel');
        halt;   
    end;
    frame    := j_frame('move and drag the Mouse');
    j_setsize(frame,430,240);
    j_setnamedcolorbg(frame,J_LIGHT_GRAY);
    
    canvas1  := j_canvas(frame,200,200);
    canvas2  := j_canvas(frame,200,200);

    j_setpos(canvas1,10,30);
    j_setpos(canvas2,220,30);

    pressed  := j_mouselistener(canvas1,J_PRESSED);
    dragged  := j_mouselistener(canvas1,J_DRAGGED);
    released := j_mouselistener(canvas1,J_RELEASED);
    entered  := j_mouselistener(canvas2,J_ENTERERD);
    moved    := j_mouselistener(canvas2,J_MOVED);
    exited   := j_mouselistener(canvas2,J_EXITED);

    j_show(frame);

    (* Waiting for actions *)
    repeat

        obj := j_nextaction;
        
        if(obj = pressed) then begin
            j_getmousepos(pressed,x,y);
            startx:=x;
            starty:=y;
        end;
        
        if(obj = dragged) then begin
            j_getmousepos(dragged,x,y);    
            j_drawrect(canvas1,startx,starty,x-startx,y-starty);
        end;
        
        if(obj = released) then begin
            j_getmousepos(released,x,y);    
            j_drawrect(canvas1,startx,starty,x-startx,y-starty);
        end;

        if(obj = entered) then begin
            j_getmousepos(entered,x,y);
            startx:=x;
            starty:=y;
        end;
 
        if(obj = moved) then begin
            j_getmousepos(moved,x,y);    
            j_drawline(canvas2,startx,starty,x,y);
            startx:=x;
            starty:=y;
        end;

        if(obj = exited) then begin
            j_getmousepos(exited,x,y);
            j_drawline(canvas2,startx,starty,x,y);
        end;

    until(obj = frame);
    
    j_quit;
end.
