program panelexample;

{$X+}

{$ifdef GPC}
	uses japi,Strings;
{$else}
	uses japi,Sysutils;
{$endif}


var 
               
    frame,panel,menubar,jfile,
    doit,quit,jlabel,obj,
    p_width,p_height,x,y,dx,dy,
    l_width,l_height             : integer;
    run                          : boolean;         
    pstr,wstr,hstr               : String;
    cstr                         : PChar;
    
begin    
    getmem(cstr,256);
    
    p_width  := 256;
    p_height := 256;
    dx       :=   2;
    dy       :=   1;
    run      := false;
           
    if( j_start = false ) then begin
        writeln('cannot connect to JAPI Kernel');
        halt;   
    end;
        
    frame   := j_frame('better moving label');
    menubar := j_menubar(frame);
    jfile   := j_menu(menubar,'File');
    doit    := j_menuitem(jfile,'Start');
    quit    := j_menuitem(jfile,'Quit');

    j_setborderlayout(frame);
    panel   := j_panel(frame);

    j_show(frame);

    jlabel  := j_label(panel,'256:256');
    j_setpos(jlabel,120,120);
        
    while(true) do begin            

        if(run) then
            obj:=j_getaction
        else
            obj:=j_nextaction;
        
        if(obj = doit) then begin
            if(not run) then begin
                run := true;
                j_settext(doit,'Stop');
                end    
            else begin
                run := false;
                j_settext(doit,'Start');    
            end;
        end;

        if(obj = panel) then begin
            p_width  := j_getwidth(panel);
            p_height := j_getheight(panel);
            Str(p_width,wstr);
            Str(p_height,hstr);
            pstr   := wstr+':'+hstr;
            
            j_settext(jlabel,StrPCopy(cstr,pstr));
            l_width  := j_getwidth(jlabel);
            l_height := j_getheight(jlabel);
            x := (p_width-l_width) div 2;
            y := (p_height-l_height) div 2;
            j_setpos(jlabel,x,y);
        end;

        if(run) then begin
            if((x+l_width  >= p_width)  or (x < 1)) then dx := -dx;
            if((y+l_height >= p_height) or (y < 1)) then dy := -dy;
            x:=x+dx;
            y:=y+dy;
            j_setpos(jlabel,x,y);
            j_sync;
            j_sleep(10);
        end;   

        if((obj = quit) or (obj = frame)) then
            break;
    end;        
    j_quit;           
                
end.
