program rubberband;

{$X+}

uses japi;

var 
    frame,canvas,obj,
    pressed,dragged,
    startx,starty,x,y  : int;

begin
    j_setdebug(4);

    if( j_start = false ) then begin
        writeln('cannot connect to JAPI Kernel');
        halt;   
    end;
 
    frame    := j_frame('Rubberband');

    canvas   := j_canvas(frame,230,220);
    j_setpos(canvas,10,30);

    j_show(frame);
    j_pack(frame);

    pressed  := j_mouselistener(canvas,J_PRESSED);
    dragged  := j_mouselistener(canvas,J_DRAGGED);

    j_setnamedcolor(canvas,J_BLUE);
    j_fillrect(canvas,0,0,230,110);
    j_setnamedcolor(canvas,J_YELLOW);
    j_fillrect(canvas,0,110,230,110);

    j_setnamedcolor(canvas,J_RED);

    startx := 0;
    starty := 0;
    x      := 0;
    y      := 0;
    obj    := 0;
    
    while(obj <> frame) do begin

        obj := j_nextaction;

        if(obj = pressed) then begin
            j_setxor(canvas,true);
            j_drawrect(canvas,startx,starty,x-startx,y-starty);
            j_getmousepos(pressed,x,y);
            startx := x;
            starty := y;
        end;

        if(obj = dragged) then begin
            j_setxor(canvas,true);
            j_drawrect(canvas,startx,starty,x-startx,y-starty);
            j_getmousepos(dragged,x,y);
            j_drawrect(canvas,startx,starty,x-startx,y-starty);
            j_setxor(canvas,false);
        end;
    end;
    
    j_quit;

end.