program scrollpane_example;

uses japi;

type str = String[255];

var 
               
    frame,obj,scrollpane,vscroll,hscroll,canvas    : integer; 
    x,y,width,height                : integer;             

begin    
    if( j_start = false ) then begin
        writeln('cannot connect to JAPI Kernel');
        halt;   
    end;
         
    frame       := j_frame('Scrollpane Demo');
    j_setborderlayout(frame);
    
    scrollpane  := j_scrollpane(frame);
    vscroll     := j_vscrollbar(scrollpane);
    hscroll     := j_hscrollbar(scrollpane);
    
    canvas:=j_canvas(scrollpane,400,400);

    j_setsize(scrollpane,180,150);
    
    j_pack(frame);
    j_show(frame);
    
    for x:=0 to 40 do begin
        j_drawline(canvas,10*x,0,0,400-10*x);                
        j_drawline(canvas,10*x,400,400,400-10*x);                
    end;

    repeat            
        obj:=j_nextaction;

        if(obj = scrollpane) then begin
            width  := j_getviewportwidth(scrollpane);
            height := j_getviewportheight(scrollpane);
        end;
            
        if(obj = hscroll) then 
            x:=j_getvalue(hscroll);
        if(obj = vscroll) then
            y:=j_getvalue(vscroll);
         
        writeln('Viewport X = ',x,x+width,' Width  = ',width);
        writeln('         Y = ',y,y+height,' Height = ',height);
     
    until (obj = frame);
    j_quit;     
                  
end.
