program textfield;

{$X+}

uses japi;

var 
    frame,menubar,jfile,jnew,save,quit,obj : integer;
    edit,selall,cut,copy,paste             : integer;
    text,selstart,selend                   : integer;
    newtext,inhalt                         : PChar;

begin    
    newtext := 'JAPI (Java Application'  + #10 +
               'Programming Interface)'  + #10 +
               'a platform and language' + #10 +
               'independent API'+ #0 ;
    
    getmem(inhalt,65535);
    
    if( j_start = false ) then begin
        writeln('cannot connect to JAPI Kernel');
        halt;   
    end;
        
    frame   := j_frame('A simple editor');
    menubar := j_menubar(frame);
    jfile   := j_menu(menubar,'File');
    jnew     := j_menuitem(jfile,'New');
    save    := j_menuitem(jfile,'Save');
    j_seperator(jfile);
    quit    := j_menuitem(jfile,'Quit');

    edit    := j_menu(menubar,'Edit');
    selall  := j_menuitem(edit,'Select All');
    j_seperator(edit);
    cut     := j_menuitem(edit,'Cut');
    copy    := j_menuitem(edit,'Copy');
    paste   := j_menuitem(edit,'Paste');

    text    := j_textarea(frame,25,12);
    j_setpos(text,10,60);
    j_settext(text,newtext);

    j_show(frame);
    j_pack(frame);
        
    while(true) do begin            
            
        obj:=j_nextaction;

        if(obj = text) then
            writeln('text changed length = ',j_getlength(text));

        if(obj = jnew) then
            j_settext(text,newtext);

        if(obj = save) then begin
            j_gettext(text,inhalt);
            writeln(inhalt);
        end;

        if(obj = selall) then
            j_selectall(text);

        if((obj = cut) or (obj = copy) or (obj = paste)) then begin
            selstart := j_getselstart(text);
            selend   := j_getselend(text);
        end;
        
        if(obj = cut) then begin
            j_delete(text,selstart,selend);
            j_selecttext(text,selstart,selstart);
        end;
        
        if(obj = copy) then
            j_getseltext(text,inhalt);

        if(obj = paste) then begin
            if(selstart = selend) then
                j_inserttext(text,inhalt,j_getcurpos(text))
            else
                j_replacetext(text,inhalt,selstart,selend);
            j_setcurpos(text,selstart);
        end;
        
        if((obj = frame) or (obj = quit)) then
            break;
            
    end;
    j_quit;           
    

end.
