program image_viewer;

{$x+}

{$ifdef GPC}
    uses japi,Strings;
{$else}
    uses japi,Sysutils;
{$endif}

var 
    frame,canvas,menubar,obj,                
    jfile,open,bmp,ppm,quit,
    image,retval            : int; 
    filename                : PChar;
begin
    getmem(filename,1024);

    if( j_start = false ) then begin
        writeln('cannot connect to JAPI Kernel');
        halt;   
    end;

    (* Generate Graphical Objects *)
    frame   := j_frame('Image Viewer');
    menubar := j_menubar(frame);
    jfile    := j_menu(menubar,'File');
    open    := j_menuitem(jfile,'Open');
    bmp     := j_menuitem(jfile,'Save BMM');
    ppm     := j_menuitem(jfile,'Save PPM');
    j_seperator(jfile);    
    quit    := j_menuitem(jfile,'Quit');

    canvas  := j_canvas(frame,320,240);
    j_setgridlayout(frame,1,1);
    j_setresizable(frame,false);
    j_disable(bmp);
    j_disable(ppm);
    j_pack(frame);
    j_show(frame);
    StrPCopy(filename,'images');
    
    obj:=0;
    while((obj <> quit) and (obj <> frame)) do begin
        obj:=j_nextaction;
    
        if(obj=open) then begin
            filename:=j_fileselect(frame,'Open File','*',filename);
            if(strlen(filename)<>0) then begin
                image  := j_loadimage(filename);
                if(image = -1) then
                    retval:=j_alertbox(frame,'Warning','Not a valid image file','Shit')
                else begin
                    j_setsize(canvas,j_getwidth(image),j_getheight(image));
                    j_pack(frame);
                    j_setnamedcolorbg(canvas,J_WHITE);
                    j_drawimage(canvas,image,0,0);
                    j_enable(bmp);
                    j_enable(ppm);
                end;
             end;
        end;
        
        if(obj=bmp) then begin
            j_fileselect(frame,'Save as BMP','*.BMP',filename);
            if(StrComp(filename,'')<>0) then
                j_saveimage(image,filename,J_BMP);            
        end;

        if(obj=ppm) then begin
            j_fileselect(frame,'Save as PPM','*.PPM',filename);
            if(StrComp(filename,'')<>0) then
                 j_saveimage(image,filename,J_PPM);            
        end

    end;

    j_quit;
end.

