program window_example;

{$X+}

{$ifdef GPC}
	uses japi,Strings;
{$else}
	uses japi,Sysutils;
{$endif}

var 
    frame,obj,window,jlabel,released,pressed,
    x,y,fx,fy                                 : int;    
    message,xstr,ystr                         : String;
    cstr                                      : PChar;

begin    
    getmem(cstr,256);
    
    if( j_start = false ) then begin
        writeln('cannot connect to JAPI Kernel');
        halt;   
    end;
        
    frame    := j_frame('Windows Demo');

    window   := j_window(frame);
    j_setflowlayout(window,J_HORIZONTAL);

    jlabel   := j_label(window,'');
    j_setnamedcolorbg(jlabel,J_YELLOW);
        
    pressed  := j_mouselistener(frame,J_PRESSED);
    released := j_mouselistener(frame,J_RELEASED);

    j_show(frame);
    
    repeat

        obj:=j_nextaction;
        
        if(obj = pressed) then begin
            j_getpos(frame,fx,fy);
            j_getmousepos(pressed,x,y);
            str(x,xstr);
            str(y,ystr);
            message := 'Mouse pressed at '+xstr+':'+ystr;
            j_settext(jlabel,StrPCopy(cstr,message));
            j_pack(window);
            j_show(window);
            j_setpos(window,fx+x,fy+y);
        end;
            
        if(obj = released) then 
            j_hide(window);
            
    until (obj = frame);
    j_quit;

end.
