program windowlistener;

uses japi;

var 
    frame,text,obj,activated,deactivated,
    opened,closed,iconfied,deiconfied:     integer;

begin    
        
    if( j_start = false ) then begin
        writeln('cannot connect to JAPI Kernel');
        halt;   
    end;
        
    frame       := j_frame('Window Listener');
    j_setgridlayout(frame,1,1);

    text        := j_textarea(frame,80,25);

    opened      := j_windowlistener(frame,J_OPENED);
    closed      := j_windowlistener(frame,J_CLOSED);
    activated   := j_windowlistener(frame,J_ACTIVATED);
    deactivated := j_windowlistener(frame,J_DEACTIVATED);
    iconfied    := j_windowlistener(frame,J_ICONIFIED);
    deiconfied  := j_windowlistener(frame,J_DEICONIFIED);

    j_show(frame);
    j_pack(frame);

    obj:=0;
    while(obj<>frame) do begin            
            
        obj:=j_nextaction;

        if(obj=opened) then j_appendtext(text,'Frame opened'+#10);

        if(obj=closed) then j_appendtext(text,'Frame closed'+#10);

        if(obj=activated) then j_appendtext(text,'Frame activated'+#10);

        if(obj=deactivated) then j_appendtext(text,'Frame deactivated'+#10);

        if(obj=iconfied) then j_appendtext(text,'Frame iconfied'+#10);

        if(obj=deiconfied) then j_appendtext(text,'Frame deiconfied'+#10);

    end;
    
    j_appendtext(text,'Frame closing, press again closing icon'+#10);

    while(j_nextaction<>frame) do ;
    j_dispose(frame);

    while(j_nextaction<>closed) do ;
    writeln('Frame closed');

    j_quit;           
    
end.


