#include <stdio.h>
#include <qapplication.h>
#include <qwidget.h>
#include <qmainwindow.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qqueue.h>
#include <qlabel.h>
#include <qpainter.h>

static Qt* obj[65535];
static int count=0,ev;
static QQueue<int> eventqueue;
QColor* col;

class eventlistener : public QObject
{
public:
	int type;
	int owner;

	bool eventFilter(QObject *o, QEvent *e)
	{
		if(e->type() == type)
		{
			printf("Event in %d\n",owner);
			eventqueue.enqueue(&owner);
		}
		fflush(stdout);
		return(true);
	}
};


class menulistener : public QObject
{
int nev;

Q_OBJECT
public slots:


	void enqueue(int o)
	{
		printf("MenuEvent in %d\n",o);
		fflush(stdout);
		nev=o;
		eventqueue.enqueue(&nev);
	//	return(true);
	}
};

/*class MenuItem : public QCustomMenuItem
{
private:
    QString *string;
    QFont *font;
public:
    MenuItem(char *s, QFont *f )
    {
        string=new QString( s );
        font=f;
	}
*/
//    void paint( QPainter* p, const QColorGroup& /*cg*/, bool /*act*/, bool /*enabled*/, int x, int y, int w, int h )
/*    {
        p->setFont ( *font );
        p->drawText( x, y, w, h, QCustomMenuItem::AlignLeft | QCustomMenuItem::AlignVCenter |
                                 QCustomMenuItem::ShowPrefix | QCustomMenuItem::DontClip, *string );
    }

    QSize sizeHint()
    {
        return QFontMetrics(*font).size( QCustomMenuItem::AlignLeft | QCustomMenuItem::AlignVCenter |
                                   QCustomMenuItem::ShowPrefix | QCustomMenuItem::DontClip,  *string );
    }
};
*/

class MyMenuItem : public QCustomMenuItem
{
public:
    MyMenuItem( const QString& s, const QFont& f )
        : string( s ), font( f ){};
    ~MyMenuItem(){}

    void paint( QPainter* p, const QColorGroup& /*cg*/, bool /*act*/, bool /*enabled*/, int x, int y, int w, int h )
    {
        p->setFont ( font );
        p->drawText( x, y, w, h, AlignLeft | AlignVCenter | ShowPrefix | DontClip, string );
    }

    QSize sizeHint()
    {
        return QFontMetrics( font ).size( AlignLeft | AlignVCenter | ShowPrefix | DontClip,  string );
    }
private:
    QString string;
    QFont font;
};



int j_start(int argc, char **argv)
{
	obj[count++] = new QApplication(argc,argv);
//	eventqueue = new QQueue();
	return(1);
}

int j_frame(char* title)
{
	obj[count] = new QMainWindow();
	((QMainWindow*)obj[count])->setCaption(QString(title));
	obj[count+1] = new eventlistener();
	((eventlistener*)obj[count+1])->type=QEvent::Close;
	((eventlistener*)obj[count+1])->owner=count;
	((QObject*)obj[count])->installEventFilter((QObject*)obj[count+1]);
	count+=2;
	return(count-2);
}

int j_canvas(int o, int w, int h)
{
	obj[count] = new QWidget((QWidget*)obj[o]);
	((QWidget*)obj[count])->resize(w,h);
	((QWidget*)obj[count])->setBackgroundColor(Qt::white);
	obj[count+1] = new eventlistener();
	((eventlistener*)obj[count+1])->type=QEvent::Resize;
	((eventlistener*)obj[count+1])->owner=count;
	((QObject*)obj[count])->installEventFilter((QObject*)obj[count+1]);
	obj[count+2]= new QPainter(((QWidget*)obj[count]));
	obj[count+3]= new QPen();
	((QPainter*)obj[count+2])->setPen(*((QPen*)obj[count+3]));
	count+=4;
	return(count-4);
}

int j_menubar(int o)
{
	obj[count] = new QMenuBar((QMainWindow*)obj[o]);
	return(count++);
}

int j_menu(int o, char* title)
{
	obj[count] = new QPopupMenu;
	obj[count+1] = new menulistener;
	QObject::connect((QObject*)obj[count],SIGNAL(activated(int)),(QObject*)obj[count+1],SLOT(enqueue(int)));
	((QMenuBar*)obj[o])->insertItem(title,(QPopupMenu*)obj[count]);
	count+=2;
	return(count-2);
}

int j_menuitem(int o, char* title)
{
	obj[count] = new MyMenuItem(title,*(new QFont()));
	((QPopupMenu*)obj[o])->insertItem((MyMenuItem*)obj[count],count);
	count+=2;
	return(count-2);
//	oder
//	((QPopupMenu*)obj[o])->insertItem(title,count);
//	return(count++);
}

void j_show(int o)
{
	((QWidget*)(obj[o]))->show();
}

void j_pack(int o)
{
	((QWidget*)obj[o])->adjustSize();
}

int j_nextaction()
{
	while(eventqueue.isEmpty())
		((QApplication*)obj[0])->processOneEvent();
	return(*(eventqueue.dequeue()));
}

int j_getaction()
{
	((QApplication*)obj[0])->processEvents(0);
	if(eventqueue.isEmpty())
		return(-1);
	else
		return(*(eventqueue.dequeue()));
}

void j_setcolor(int o, char r, char g, char b)
{
//	((QPen*)obj[o+3])->setColor(*(new QColor(r,g,b)));
	col = new QColor(r,g,b);
//	((QWidget*)obj[o])->setBackgroundColor(*col);
}

void j_drawpixel(int o,int x,int y)
{
//	((QPainter*)obj[o+2])->drawPoint(x,y);
	QPainter p((QWidget*)obj[o]);

//	p.begin((QWidget*)obj[o]);
	p.setPen(*col);
//	p.drawPoint(x,y);
	p.drawLine(x,y,100,100);
	p.flush();
//	p.end();

//((QWidget*)obj[o])->setBackgroundColor(*col);

}

int main(int argc, char** argv)
{

	int breite=255;
	int hoehe=255;
	int x,y,do_work=0;

	/* graphical Objects */
	int frame,menubar;
	int file,calc;
	int quit,start,stop;
	int canvas,obj;

	if(!j_start(argc, argv))
	{	printf("can't connect to JAPI Kernel \n");return(0); }

	/* Generate Graphical Objects */
	frame 	= j_frame("Colors");

	menubar = j_menubar(frame);

	file 	= j_menu(menubar,"File");
	calc 	= j_menu(menubar,"Colors");
	quit 	= j_menuitem(file,"Quit");

	start 	= j_menuitem(calc,"Start");
	stop 	= j_menuitem(calc,"Stop");


	canvas  = j_canvas(frame,breite,hoehe);
//	j_setpos(canvas,10,60);

	j_show(frame);
	j_pack(frame);

	/* Waiting for actions */
	x=-1,y=-1;
	obj=0;
	while((obj!=quit)&&(obj!=frame))
	{
		if(do_work)
			obj=j_getaction();
		else
			obj=j_nextaction();
//printf("%d\n",obj);
//fflush(stdout);
		if(obj==start)
			do_work=1;
		if(obj==stop)
			do_work=0;

		if(do_work)
		{
			x=(x+1)%breite;
			if(x==0)
				y=(y+1)%hoehe;
			if((x==breite-1) && (y==hoehe-1))
				do_work=0;
			else
			{
				j_setcolor(canvas,(char)(x),(char)(y),(char)(x+y));
				j_drawpixel(canvas,x,y);
			}
		}
	}
//	j_quit();

    return(0);
}


#include "japilib.moc"