import java.awt.*;
import java.util.Hashtable;

public class JAPI_Fixlayout implements LayoutManager
{
    private Hashtable hash = new Hashtable();
    int hgap=5;
    int vgap=5;
	Insets oldinsets;
	
    public int getHgap()
    {
		return hgap;
    }
    public int getVgap()
    {
		return vgap;
    }

    public void setHgap(int hgap)
    {
		this.hgap = hgap;
    }
    public void setVgap(int vgap)
    {
		this.vgap = vgap;
    }

    public void addLayoutComponent(String s, Component comp)
    {}

    public void removeLayoutComponent(Component comp)
    {}

    public Dimension preferredLayoutSize(Container target)
    {
        Insets    insets  = target.getInsets();
        Dimension dim     = new Dimension(0,0);
        Rectangle size    = new Rectangle(0,0);

        for (int i = 0 ; i < target.getComponentCount() ; i++)
        {
            Component comp = target.getComponent(i);

            if(comp.isVisible())
            {
		        Dimension d = comp.getSize();
                Rectangle compSize = new Rectangle(comp.getLocation());
   	            compSize.setSize(d.width, d.height);
                size = size.union(compSize);
            }
        }
        dim.width  += size.width + insets.right + hgap;
        dim.height += size.height + insets.bottom + vgap;

        return dim;
    }


    public Dimension minimumLayoutSize(Container target)
    {

        Insets    insets      = target.getInsets();
        Dimension dim         = new Dimension(0,0);
        Rectangle minBounds   = new Rectangle(0,0);

        for (int i = 0 ; i < target.getComponentCount() ; i++)
        {
            Component comp = target.getComponent(i);

            if(comp.isVisible())
            {
                Dimension d = comp.getMinimumSize();
                Rectangle compMinBounds = new Rectangle(comp.getLocation());
  	            compMinBounds.setSize(d.width, d.height);
                minBounds = minBounds.union(compMinBounds);
            }
        }
        dim.width  += minBounds.width  + insets.right + hgap;
        dim.height += minBounds.height + insets.bottom + vgap;

        return dim;
    }


    public void layoutContainer(Container target)
    {
           
       int       ncomponents = target.getComponentCount();
       
       for (int i = 0 ; i < ncomponents ; i++)
       {
            Component comp = target.getComponent(i);

            if(comp.isVisible())
            {
                Dimension sz   = comp.getSize();
				Dimension ps   = comp.getPreferredSize();
                Point     loc  = comp.getLocation();

				if(sz.width < ps.width || sz.height < ps.height)
					sz = ps;
                comp.setBounds(loc.x, loc.y, sz.width, sz.height);
            }
        }
	}

}
