import java.awt.*;
import javax.swing.*;
import java.io.*;

public class JAPI_Frame extends JFrame
{
	Insets inset;
	boolean resizable=true;

	public JAPI_Frame(String title)
	{
		super(title);
//		addNotify();   // WICHTIG !!!!
		super.getContentPane().setLayout(new JAPI_Fixlayout());
	}

	public Component add(Component c)
	{
		return(super.getContentPane().add(c));
	}

	public void setResizable(boolean set)
	{
		resizable=set;
		repaint(-1);
	}

//	public void paint(Graphics g)
//	{
//	    if(isResizable()!=resizable)
//	    	super.setResizable(resizable);
//	}

	public void disable()
	{
		int i;
		for(i=0;i<getComponentCount();i++)
			getComponent(i).disable();
		if(getJMenuBar() != null)
			((JAPI_Menubar)getJMenuBar()).disable();
	}

	public void enable()
	{
		int i;
 		for(i=0;i<getComponentCount();i++)
			getComponent(i).enable();
		if(getJMenuBar() != null)
			((JAPI_Menubar)getJMenuBar()).enable();
	}

	public void setInsets(int t, int b, int l, int r)
	{
		inset = new Insets(t,l,b,r);
	}

	public Insets getInsets()
	{
		if(inset != null)
			return(inset);
		else
			return(super.getInsets());
	}

    public void setBackground(Color c)
    {
    	super.setBackground(c);
		int i;
 		for(i=0;i<getComponentCount();i++)
			getComponent(i).setBackground(c);
		// menus haben keine Funktionen zum Setzen der Farben
    }

    public void setFont(Font f)
    {
		int i;
   		super.setFont(f);
		for(i=0;i<getComponentCount();i++)
			if(getComponent(i).getPeer() != null)
				getComponent(i).setFont(f);
		if(getJMenuBar() != null)
			((JAPI_Menubar)getJMenuBar()).setFont(f);
   }
}
