import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;

public class JAPI_Graphicbutton extends Canvas
{
  	// Charakteristische Gren des Buttons
  	private boolean pressed;
  	private boolean mousein;

   	private Image picture;  // Bild des Buttons
   	private Color bgc = new Color(0);
   	private Dimension prefSize = new Dimension(0,0);

	private JAPI_SocketOutputStream JAPI_actionstream;
	private int JAPI_id;

  	public JAPI_Graphicbutton(String filename, String host, int port, int id, JAPI_SocketOutputStream action)
  	throws MalformedURLException
  	{
    	pressed = false;
     	mousein = false;

        picture = Toolkit.getDefaultToolkit().getImage(new URL("http",host,port,filename));

    	MediaTracker tracker = new MediaTracker(this);
    	tracker.addImage(picture, 0);
    	try {tracker.waitForID(0);} catch(InterruptedException e) {System.err.println("Error: "+e);}

	    prefSize.width  = picture.getWidth(this) + 6;
     	prefSize.height = picture.getHeight(this)+ 6;

  		this.setSize( prefSize.width, prefSize.height);

 		JAPI_actionstream = action;
 		JAPI_id = id;

        bgc = Color.lightGray;
   	}

	public void setImage(Image img)
	{
		picture=img;
        paint(getGraphics());
	}

	public void setSize(int width, int height)
	{
    	prefSize = new Dimension(width, height);
 		super.setSize(prefSize.width, prefSize.height);
	}

	public Dimension getPreferredSize()
	{
    	return prefSize;
  	}

  	public Dimension getMinimumSize()
  	{
    	return prefSize;
  	}

	public void disable()
	{
		bgc=Color.gray;
        super.disable();
        paint(getGraphics());
	}

	public void enable()
	{
		bgc=Color.lightGray;
        super.enable();
        paint(getGraphics());
	}

  	public void paint(Graphics g)
  	{
        g.setColor(bgc);

   		// Ist Button gedrckt und Maus im Button
    	if (pressed && mousein)
		{
  		   	g.draw3DRect(0, 0, prefSize.width, prefSize.height, false);
      		g.fill3DRect(1, 1, prefSize.width-1, prefSize.height-1, false);
      		g.drawImage(picture, 4, 4, prefSize.width-6, prefSize.height-6, this);
    	}
		else
		{
    		g.draw3DRect(0, 0, prefSize.width, prefSize.height, true);
      		g.fill3DRect(1, 1, prefSize.width-1, prefSize.height-1, true);
      		g.drawImage(picture, 3, 3, prefSize.width-6, prefSize.height-6, this);
 		}
   	}

  	public boolean mouseUp(Event evt, int x, int y)
  	{
    	if (pressed)
    	{
 	 		try
			{
				JAPI_actionstream.sendInt(JAPI_id);
			}
			catch(IOException exce) {}
  	     	pressed = false; // Button nicht mehr gedrckt
    	}
    	repaint();         // Button neu zeichnen
    	return false;
  	}

  	public boolean mouseDown(Event evt, int x, int y)
  	{
    	pressed = true;    // Button gedrckt
    	repaint();         // Button neu zeichnen
    	return true;
  	}

  	public boolean mouseExit(Event evt, int x, int y)
  	{
     	mousein = false;  // Maus ausserhalb des Buttons
     	repaint();        // Button neu zeichnen
     	return true;
  	}

  	// Aufruf bei Eintreten in den Button
  	public boolean mouseEnter(Event evt, int x, int y)
  	{
    	mousein = true;    // Maus innerhalb des Buttons
    	repaint();         // Button neu zeichnen
    	return true;
  	}


}






