import java.awt.*;

public class JAPI_Led extends JAPI_ValueComponent
{

	private Color off;
    private int form;
    private boolean on=false;

    public JAPI_Led (int dw, int dh, int f, Color c)
    {
		super.setSize(dw,dh);
		this.setForeground(c);
		this.form=f;
    }

    public void setState(boolean b)
    {
	    if(b!=this.on)
	    {
	    	this.on = b;
        	repaint();
        }
    }

	public void setForeground(Color c)
	{
		super.setForeground(c);
 		off=new Color(c.getRed()/3,c.getGreen()/3,c.getBlue()/3);
 	}

    public void paint(Graphics g)
    {
 		Dimension d = super.size();

        if(form==0)
        {
        	g.setColor(off);
			g.draw3DRect(0,0,d.width-1,d.height-1,true);
			g.draw3DRect(1,1,d.width-3,d.height-3,true);
        	if (on)
        	    g.setColor(getForeground());
        	else
        	    g.setColor(off);
			g.fillRect(2,2,d.width-4,d.height-4);
  	      	g.setColor(Color.black);
  	      	g.drawRect(0,0,d.width,d.height);
		}
		else
		{
 			g.setColor(off);
  	      	g.fillOval(0,0,d.width-1,d.height-1);
  	      	g.setColor(Color.black);
  	      	g.drawOval(0,0,d.width-1,d.height-1);

        	if (on)
        	    g.setColor(getForeground());
        	else
        	    g.setColor(off);

			g.fillOval(2,2,d.width-5,d.height-5);

       		g.setColor(Color.white);
			g.fillOval(d.width/4,d.height/4,3,3);
	    }
	}
}

