import java.awt.*;

public class JAPI_Panel extends Panel
{
	Insets inset;
	int type=1;

	public JAPI_Panel(int t)
	{
		super(); 
	     	type = t;
		this.setLayout(new JAPI_Fixlayout());
		if(t!=JAPI_Const.J_NONE)
			inset = new Insets(4,4,4,4);
	}

	public void disable()
	{
		int i;
		for(i=0;i<getComponentCount();i++)
			getComponent(i).disable();
	}
     
	public void enable()
	{
		int i;
 		for(i=0;i<getComponentCount();i++)
			getComponent(i).enable();
	}
   
	public void setInsets(int t, int b, int l, int r)
	{
		inset = new Insets(t,l,b,r);
	}

	public Insets getInsets()
	{
		if(inset != null)
			return(inset);
		else
			return(super.getInsets());
	}
			
    public void setFont(Font f)
    {
		int i;
   		super.setFont(f);
		for(i=0;i<getComponentCount();i++)
			if(getComponent(i).getPeer() != null)
				getComponent(i).setFont(f);
   	}
   	
    public void paint(Graphics g) 
 	{
        Dimension d = size();
        Color bg = getBackground();
 
        g.setColor(bg);
        
        switch(type)
        {
        	case(JAPI_Const.J_LINEDOWN):	/* Linie down */
        				g.draw3DRect(1, 1, d.width-2, d.height-2, false);
        				g.draw3DRect(2, 2, d.width-4, d.height-4, true);
						break;
			case(JAPI_Const.J_LINEUP):	/* Linie up */
				        g.draw3DRect(1, 1, d.width-2, d.height-2, true);
				        g.draw3DRect(2, 2, d.width-4, d.height-4, false);
						break;
			case(JAPI_Const.J_AREADOWN):	/* Flaeche down */
				        g.draw3DRect(1, 1, d.width-2, d.height-2, false);
//				        g.draw3DRect(2, 2, d.width-4, d.height-4, false);
						break;
        	case(JAPI_Const.J_AREAUP):	/* Flaeche up */
				        g.draw3DRect(1, 1, d.width-2, d.height-2, true);
//				        g.draw3DRect(2, 2, d.width-4, d.height-4, true);
    	}
    }
}
