import java.io.*;
import java.awt.*;
import java.awt.event.*;

public class JGI_Focuslistener implements FocusListener
{
	JAPI_SocketOutputStream JGI_commandstream;
	JAPI_SocketOutputStream JGI_actionstream;
	int JGI_id;		
	int haveFocus=0;
	int debuglevel=0;	
	
	public JGI_Focuslistener(int object_id,  JAPI_SocketOutputStream command, JAPI_SocketOutputStream action ) 
	throws IOException
	{
		JGI_commandstream=command;
		JGI_actionstream=action;
		JGI_id = object_id;		
		JGI_commandstream.sendInt(JGI_id);
	}
	
	public void hasfocus() throws IOException
	{
		JGI_commandstream.sendInt(haveFocus);
	} 

	public void focusGained(FocusEvent e)
	{
		if(debuglevel > 1) System.out.println("Focus Gained: "+this.JGI_id);		
		try
		{	
			JGI_actionstream.sendInt(JGI_id);
		}	
		catch(IOException exce) {}		
		haveFocus=1;
	}

	public void focusLost(FocusEvent e)
	{
		if(debuglevel > 1) System.out.println("Focus Lost: "+this.JGI_id);		
		try
		{	
			JGI_actionstream.sendInt(JGI_id);
		}	
		catch(IOException exce) {}		
		haveFocus=0;
	}
	
	public void setdebuglevel(int level)
	{
		debuglevel=level;
	}
	
}